    
#lang "fb"
'option gosub

#DEFINE __STORY_DEBUG__

Const _ConstPath = __PATH__

Const _ConstEngine_ = "Story 6"
Const _ConstBuild_ = "v6-3-1 r22"
Const _ConstAuthor_ = "Keal"

#define _Engine_ Story 6
#define _BuildVer_ v6.3.1 r22
#define _Build_ v6-3-1 r22
#define _Version_ v6-3-1 r22

#define _IncPath_ ../_Engine_ (_Build_)/./
#define _DefaultGamepack_ _Engine_

Const _ConstDefaultGamepack_ = "Story 6"

Const _ConstIncPath_ = "../" & _ConstEngine_ & " (" & _ConstBuild_ & ")/./"
Const _ConstIncPathStr_ = "../" & _ConstEngine_ & " (" & _ConstBuild_ & ")/./"

Declare Function SimpleWait ( Message As String ="", _Color As uLong = &HFFFFFFFF ) As String

Declare Function PageIndex ( PIndex As Long = 0, Digits As Long = 3 ) As String
 
Const CR = Chr ( 13 )
Const SP = Chr ( 32 )

Const CRLF = Chr ( 13 ) & Chr ( 10 )
Const EQ = Chr ( 61 )

Const QUOT = Chr ( 34 )
Const COMMA = Chr ( 44 )
Const COLON = Chr ( 58 )
Const SEMI = Chr ( 59 )

Const VARSEP = COLON & COLON

Const _constDefaultGamepack_ = "Story 6"

Dim Shared As String CMD
CMD = Command ( )

Type Gamepack_Main_Type
	As String Root, Pack, Font, Pal
	As Long W, H
End Type

Dim Shared As Gamepack_Main_Type Gamepack

With Gamepack
	.Root = "Gamepacks\"
	.Pack = _constDefaultGamepack_
	.Font = "Mishap22.png"
	.Font = "Mishap22.png"
	.Pal = "VGA_Table.seq"
	.W = 40
	.H = 30
End With


Dim Shared As String Child_Path, Parent_Path, Game_Dir
Dim Shared As String _sharedBuild_, _sharedTitle_, _sharedAuthor_

Declare Sub Outro ( )
Declare Function Author ( ) As String
Declare Function Title ( ) As String
Declare Function Build ( ) As String
Declare Sub Path ( )

_sharedAuthor_ = Author ( )
_sharedBuild_ = Build ( )
_sharedTitle_ = Title ( )

Windowtitle ( _sharedTitle_ )

ScreenRes 640, 480, 32, 16
ScreenSet 1, 0

SimpleWait ( )

'#define _IncPath_ ../_Engine_ (_Build_)/./

/' Meta Commands Contributed By Mysoft Jan 1st 2023
( As Updated By Keal Mar 5th 2023 )'/

#define __Include(_s) #include once #_s
#define Include2(_l,_m,_r) __Include(_l##_m##_r)

Include2( , file, .bi )
Include2( , crt/math, .bi )
Include2( , crt, .bi )
Include2( , fbgfx, .bi )
Include2( , fbimage, .bi )
Include2( , vbcompat, .bi )

Using FB.Graphics

Include2( _IncPath_, Core/Code/File Support, .bas )
Include2( _IncPath_, Core/Code/String Support, .bas )
Include2( _IncPath_, Core/Code/VGA Lookup, .bas )
Include2( _IncPath_, Core/Code/Gfx Manip/Gfx Manip, .bas )

Include2( _IncPath_, _Engine_/Code/Page/Allocation (_Version_)/Allocation Struct, .bas )

Include2( _IncPath_, Core/Code/Text Box, .bas )

Include2( _IncPath_, Core/Code/SEQ22/SEQ22 All-In-One, .bas )

Include2( _IncPath_, Core/Code/SEQ22/SEQ22 Demo, .bas )

'''''SEQ_Demo ( )

Declare Function Simplify_Path ( ThisPath As String ) As String

Declare Sub Path_Parts ( ThisPath As String, ByRef Engine As String, ByRef Version As String )

Dim Shared As String Local_Path

Dim Shared As String _sharedPath_, _sharedEngine_, _sharedVersion_

_sharedPath_ = Simplify_Path ( __PATH__ )

Path_Parts ( _sharedPath_, _sharedEngine_, _sharedVersion_ )

Color RGBA ( 0, 255, 0, 255 )
Print "Path    : " & QUOT & _sharedPath_ & QUOT
Print "Engine  : " & QUOT & _sharedEngine_ & QUOT
Print "Version : " & QUOT & _sharedVersion_ & QUOT
Color RGBA ( 255, 255, 255, 255 )

SimpleWait ( )

Const Pi = 4 * Atn ( 1 )

Using FB

Include2( _IncPath_, Core/Code/WaitKey, .bas )

#IFDEF __STORY_DEBUG__
	Print _ConstEngine_ & " " & _ConstBuild_ & " / Main"
	SimpleWait ( )
#ENDIF

Include2( _IncPath_, Core/Code/Gfx Manip/Memory Management, .bas ) 

Include2( _IncPath_, Core/Code/RGBA_Macro, .bas ) 
Include2( _IncPath_, Core/Code/Common Conversions, .bas ) 
Include2( _IncPath_, Core/Code/File Support, .bas ) 
Include2( _IncPath_, Core/Code/String Support, .bas ) 
Include2( _IncPath_, Core/Code/Text Box, .bas ) 

Include2( _IncPath_, Core/Code/Cat, .bas ) 

/'
#Include Once "./zlib".bi""
#Include Once "./FBImage".bi""
'/

Include2( _IncPath_, Core/Code/SEQ22/SEQ22 All-In-One, .bas )

Include2( _IncPath_, _Engine_/Code/Page/Allocation (_Version_)/Allocation Struct, .bas )

Include2( _IncPath_, _Engine_/Code/Page/Allocation (_Version_)/Allocation Setup, .bas )

Include2( _IncPath_, _Engine_/Code/Page/Allocation (_Version_)/Allocation Page, .bas )

Include2( _IncPath_, Core/Code/Gfx Manip/Gfx Manip, .bas )

Include2( _IncPath_, _Engine_/Code/Page/Interaction/Interaction Sprite Modes, .bas )
Include2( _IncPath_, _Engine_/Code/Page/Interaction/Interaction Scenes, .bas )

Include2( _IncPath_, _Engine_/Code/Page/Page To DB, .bas )
Include2( _IncPath_, _Engine_/Code/Page/Fruit Demo, .bas )
Include2( _IncPath_, _Engine_/Code/Page/Import Gamepack, .bas )

Include2( _IncPath_, _Engine_/Code/Page/Interaction/Interaction Page, .bas )
Include2( _IncPath_, _Engine_/Code/Page/Interaction/Interaction Layers, .bas )
Include2( _IncPath_, _Engine_/Code/Page/Interaction/Interaction Scenes, .bas )

Include2( _IncPath_, _Engine_/Code/Gamepack/Gamepack Structs, .bas )
/'Include2( _IncPath_, _Engine_/Code/Gamepack/Gamepack Structs Main, .bas )'/
Include2( _IncPath_, _Engine_/Code/Gamepack/Gamepack Main, .bas )

Fruit_Demo ( )

Import_Gamepack ( )

Outro ( )

Function SimpleWait ( Message As String ="", _Color As uLong = &HFFFFFFFF ) As String

	Color _Color
	
	If Len ( Message ) > 0 Then
		Print Message
	End If
	
	Flip
	
	Dim As String CI : CI = ""

	Do While Len ( CI ) = 0
		CI = InKey ( )
		Sleep 1, 1
	Loop
	
	Select Case CI
	Case Chr ( 27 )
		Outro ( )
	Case Else
		Return CI
	End Select
	
End Function

Sub Outro ( )
	Color RGBA ( 255, 255, 255, 255 )
	Cls : Print "Goodnight, Sweet Prince.." : SimpleWait ( )
	End
End Sub

Sub Path ( )

	Child_Path = CurDir ( )
	ChDir ".." : Parent_Path = CurDir ( ) : ChDir Child_Path
	Game_Dir = Mid ( Child_Path, Len ( Parent_Path ) + 1 )
	
	Child_Path = Simplify_Path ( Child_Path )
	
	Game_Dir = Simplify_Path ( Game_Dir )

End Sub

Function Author ( ) As String
	
	Dim As Long Begin = 1
	Dim As String Temp
	_sharedAuthor_ = ""

	For Offset As Long = 1 To Len( _ConstAuthor_ ) Step 1
	
		Select Case Mid ( _ConstAuthor_, Offset, 1 )
		Case " "
			_sharedAuthor_ &= ", "
		Case "_"
			_sharedAuthor_ &= " "
		Case Else
			_sharedAuthor_ &= Mid ( _ConstAuthor_, Begin, 1 )
		End Select
	
		Begin = Offset + 1
	
	Next Offset

	Return _sharedAuthor_

End Function

Function Title ( ) As String
		
	_sharedTitle_ = Game_Dir & " (" & Build ( ) & ") by " & Author ( )
	
	Return _sharedTitle_
	
End Function

Function Build ( ) As String
	
	_sharedBuild_ = ""
	
	For Offset As Long = 1 To Len( _ConstBuild_ ) Step 1
		If Mid ( _ConstBuild_, Offset, 1 ) <> "-" Then
			_sharedBuild_ &= Mid ( _ConstBuild_, Offset, 1 )
		Else
			_sharedBuild_ &= "."
		End If
	Next Offset

	Return _sharedBuild_
	
End Function

Function PageIndex ( PIndex As Long = 0, Digits As Long = 3 ) As String
	Return Right ( String ( Digits, "0" ) & Trim ( Str ( PIndex ) ), Digits )
End Function

Function Simplify_Path ( ThisPath As String ) As String
	
	Dim As String Pre, Suf
	Pre = "" : Suf = ""
		
	ThisPath = Str_Replace ( "/", "\", ThisPath )

	ThisPath = Str_Replace ( "\.\", "\", ThisPath )
	
	Pre = Prefix ( "\..\", ThisPath )
	Suf = Suffix ( Pre & "\..\", ThisPath )

	ThisPath = Ext_Prefix ( "\", Pre ) & "\" & Suf

	ThisPath = Ext_Prefix ( ".", ThisPath )
		
	Return ThisPath
	
End Function

Sub Path_Parts ( ThisPath As String, ByRef Engine As String, ByRef Version As String )
	
	Dim As String Pre
	Pre = ""
		
	Pre = Ext_Suffix ( "\", Ext_Prefix ( "\", ThisPath ) )	

	Version = Str_Replace ( "-", ".", Ext_Suffix ( "(", Ext_Prefix ( ")", ThisPath ) ) )	

	Engine = Ext_Prefix ( " (", Pre )
		
End Sub